---
title: XTTS-V2 API Usage Guide
slug: 6DCWoM_fbbp1XuSHH8vVc
createdAt: Thu Jul 18 2024 06:12:37 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:40:04 GMT+0000 (Coordinated Universal Time)
---

# XTTS-V2 API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the XTTS-V2 API, which is used for voice cloning and text-to-speech conversion.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
        "text": "Hi there, I'm your new voice clone. Try your best to upload quality audio",
        "speaker": "https://aonweb.ai/pbxt/Jt79w0xsT64R1JsiJ0LQRL8UcWspg5J4RFrU6YwEKpOT1ukS/male.wav",
        "language": "en",
        "cleanup_voice": false
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/xtts-v2@lucataco", data, price);
    // Handle response
     console.log("XTTS-V2 result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```

### Parameter Description

- `text`: String, the text content to be converted into speech.
- `speaker`: String, the URL of the audio file used as the voice sample for cloning.
- `language`: String, specifies the language of the text, with "en" indicating English.
- `cleanup_voice`: Boolean, whether to perform cleanup processing on the generated voice.

### Notes

- Ensure that the provided audio URL is publicly accessible and of good quality to achieve the best cloning effect.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and privacy regulations, especially when handling voice samples of others.

### Example Response

The API response will contain the URL of the generated cloned voice or other relevant information. Parse and use the response data according to the actual API documentation.
